CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

  tiles    = vga#xtiles * vga#ytiles
  tiles32  = tiles * 32


OBJ

  vga : "vga_512x384_bitmap"


VAR

  long  sync, pixels[tiles32]
  word  colors[tiles]


PUB start | h, i, j, k, x, y

  'start vga
  vga.start(16, @colors, @pixels, @sync)

  'init colors to cyan on blue
  repeat i from 0 to tiles - 1
    colors[i] := $2804

  'draw some lines  
  repeat y from 1 to 8
    repeat x from 0 to 511
      plot(x, x/y)

  'wait ten seconds
  waitcnt(clkfreq * 10 + cnt)

  'randomize the colors and pixels
  repeat
    colors[||?h // tiles] := ?i
    repeat 100
      pixels[||?j // tiles32] := k?


PRI plot(x,y) | i

  if x => 0 and x < 512 and y => 0 and y < 384
    pixels[y << 4 + x >> 5] |= |< x  
    